/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.roaming.service.impl;

import com.tp_link.eap.domain.eap.Ap;
import com.tp_link.eap.domain.eap.bean.WirelessParam;
import com.tp_link.eap.domain.roaming.bean.ProbeClient;
import com.tp_link.eap.domain.roaming.bean.RoamingClientRecord;
import com.tp_link.eap.domain.roaming.bean.RoamingRelatedAp;
import com.tp_link.eap.domain.roaming.document.ApNeighborList;
import com.tp_link.eap.domain.roaming.document.RoamingClient;
import com.tp_link.eap.domain.roaming.document.RoamingSetting;
import com.tp_link.eap.domain.roaming.json.IssuedRoamingInfo;
import com.tp_link.eap.domain.roaming.json.ReportedRoamingInfo;
import com.tp_link.eap.monitor.roaming.repo.IApNeighborListRepository;
import com.tp_link.eap.monitor.roaming.repo.IRoamingClientRepository;
import com.tp_link.eap.monitor.roaming.repo.IRoamingSettingRepository;
import com.tp_link.eap.monitor.roaming.service.a;
import com.tp_link.eap.util.a.b;
import com.tp_link.eap.util.a.e;
import com.tp_link.eap.util.l;
import com.tp_link.eap.util.p.c;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="roamingService")
public class RoamingServiceImpl
implements a {
    private static final Logger a = LoggerFactory.getLogger(RoamingServiceImpl.class);
    private static int b = 20;
    private static int c = 1000;
    private static int d = 6;
    private static int e = 12;
    @Autowired
    private IRoamingClientRepository f;
    @Autowired
    private IApNeighborListRepository g;
    @Autowired
    private IRoamingSettingRepository h;
    @Autowired
    private com.tp_link.eap.monitor.record.service.a i;
    @Autowired
    private com.tp_link.eap.monitor.monitor.service.b j;
    @Autowired
    private MongoTemplate k;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleReportedRoamingInfo(String deviceId, ReportedRoamingInfo roamingInfo) {
        ProbeClient probeClient;
        ApNeighborList apNeighborList;
        Object object;
        List list;
        if (!this.a(deviceId)) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        Ap ap = this.j.getApByMac(deviceId);
        if (ap != null) {
            if (ap.getWp2g() != null && ap.getWp2g().getActualChannel() != null) {
                n2 = l.h((String)ap.getWp2g().getActualChannel());
                int n4 = n2 = n2 > 0 ? n2 : 0;
            }
            if (ap.getWp5g() != null && ap.getWp5g().getActualChannel() != null) {
                n3 = l.h((String)ap.getWp5g().getActualChannel());
                int n5 = n2 = n3 > 0 ? n3 : 0;
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(list = roamingInfo.getApNeighborTable()))) {
            a.debug("Received AP neighbor list from mac: {}", (Object)deviceId);
            object = list.iterator();
            while (object.hasNext()) {
                apNeighborList = (ApNeighborList)object.next();
                this.b(deviceId, apNeighborList);
                apNeighborList.setMac(deviceId);
                if (null == apNeighborList.getBssid()) {
                    a.warn("Reported AP BSSID is null");
                    return;
                }
                int n6 = n2;
                if (!this.a(deviceId, apNeighborList.getBssid())) {
                    n6 = n3;
                }
                probeClient = new RoamingRelatedAp(deviceId, apNeighborList.getBssid(), n6);
                this.a((RoamingRelatedAp)probeClient, apNeighborList);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(object = roamingInfo.getProbeClientList()))) {
            apNeighborList = new HashSet();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object object2;
                Object object3;
                Object object4;
                probeClient = (ProbeClient)iterator.next();
                if (null == probeClient.getBssid()) {
                    a.warn("Received probe client BSSID is null");
                    continue;
                }
                if (apNeighborList.contains(probeClient.getBssid())) continue;
                ApNeighborList apNeighborList2 = this.d(probeClient.getBssid());
                if (null == apNeighborList2) {
                    a.debug("First get probe client from mac: {}, request AP Neighbor", (Object)deviceId);
                    a.debug("DATA_TYPE_GETNEIGHBOR: {}", (Object)deviceId);
                    com.tp_link.eap.monitor.record.a.a.a(deviceId, "getNeighbor");
                } else if (apNeighborList2.getRegetNeighbor() != 0) {
                    int n7 = apNeighborList2.getRegetNeighbor();
                    object3 = object4 = com.tp_link.eap.b.b.a.a((String)apNeighborList2.getBssid());
                    synchronized (object3) {
                        apNeighborList2.setRegetNeighbor(n7 - 1);
                        this.g.save(apNeighborList2);
                    }
                    apNeighborList.add(apNeighborList2.getBssid());
                    continue;
                }
                RoamingRelatedAp roamingRelatedAp = new RoamingRelatedAp(deviceId, probeClient);
                object4 = this.a(probeClient, roamingRelatedAp);
                object3 = object4.getApList();
                Object object5 = object2 = com.tp_link.eap.b.b.a.a((String)object4.getClientMac());
                synchronized (object5) {
                    apNeighborList2 = this.a(roamingRelatedAp, (List<RoamingRelatedAp>)object3);
                }
                this.a(roamingRelatedAp, apNeighborList2);
            }
        }
    }

    private boolean a(String string, String string2) {
        if (com.tp_link.eap.util.a.e.a((String)string) || com.tp_link.eap.util.a.e.a((String)string2)) {
            return false;
        }
        return l.c((String)string).substring(3).equalsIgnoreCase(l.c((String)string2).substring(3));
    }

    @Override
    public void handleChannelChange(String deviceId, WirelessParam wirelessInfo2G, WirelessParam wirelessInfo5G) {
        if (!this.a(deviceId)) {
            return;
        }
        Ap ap = this.j.getApByMac(deviceId);
        if (ap != null) {
            String string;
            String string2;
            boolean bl = false;
            if (null != wirelessInfo2G && null != wirelessInfo2G.getActualChannel() && ap.getWp2g() != null && ap.getWp2g().getActualChannel() != null && !(string2 = wirelessInfo2G.getActualChannel()).equals(string = ap.getWp2g().getActualChannel())) {
                a.debug("channel changed, old: {}, new: {}", (Object)string, (Object)string2);
                bl = true;
            }
            if (null != wirelessInfo5G && null != wirelessInfo5G.getActualChannel() && ap.getWp5g() != null && ap.getWp5g().getActualChannel() != null && !(string2 = wirelessInfo5G.getActualChannel()).equals(string = ap.getWp5g().getActualChannel())) {
                a.debug("channel changed, old: {}, new: {}", (Object)string, (Object)string2);
                bl = true;
            }
            if (bl) {
                this.clearApRoamingInfo(deviceId, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearTimeoutRoamingClients() {
        Set set = RoamingClientRecord.getRoamingClientKeys();
        if (!CollectionUtils.isEmpty((Collection)set)) {
            for (String string : set) {
                Object object;
                RoamingClient roamingClient = RoamingClientRecord.getRoamingClient((String)string);
                if (!this.a(roamingClient)) continue;
                Object object2 = object = com.tp_link.eap.b.b.a.a((String)roamingClient.getClientMac());
                synchronized (object2) {
                    RoamingClientRecord.removeRoamingClient((String)string);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearApRoamingInfo(String mac, boolean reGetNeighbor) {
        a.debug("going to clear AP neighbor list, mac is {}", (Object)mac);
        List<ApNeighborList> list = this.c();
        if (!CollectionUtils.isEmpty(list)) {
            for (ApNeighborList apNeighborList : list) {
                Object object;
                if (apNeighborList.getMac().equals(mac)) {
                    Object object2;
                    a.debug("Removing AP Neighbor List, mac: {}, bssid: {}", (Object)mac, (Object)apNeighborList.getBssid());
                    object = object2 = com.tp_link.eap.b.b.a.a((String)apNeighborList.getBssid());
                    synchronized (object) {
                        if (reGetNeighbor) {
                            apNeighborList.setRegetNeighbor(2);
                            apNeighborList.setApList(new ArrayList());
                            this.g.save(apNeighborList);
                        } else {
                            this.g.delete(apNeighborList);
                        }
                        continue;
                    }
                }
                boolean bl = false;
                if (!CollectionUtils.isEmpty((Collection)apNeighborList.getApList())) {
                    object = apNeighborList.getApList().iterator();
                    while (object.hasNext()) {
                        RoamingRelatedAp roamingRelatedAp = (RoamingRelatedAp)object.next();
                        if (null == roamingRelatedAp.getMac() || !roamingRelatedAp.getMac().equals(mac)) continue;
                        object.remove();
                        bl = true;
                    }
                }
                this.a(apNeighborList);
                if (!bl) continue;
                a.debug("neighbor list delete, issue: {}\n{}", (Object)apNeighborList.getMac(), (Object)com.tp_link.eap.util.a.b.a((Object)apNeighborList));
                this.a(apNeighborList.getMac(), apNeighborList);
            }
        }
        a.debug("clear AP roaming info, after update, AP neighbor list is: {}", (Object)com.tp_link.eap.util.a.b.a(list));
        if (reGetNeighbor && this.a(mac)) {
            a.debug("DATA_TYPE_GETNEIGHBOR: {}", (Object)mac);
            com.tp_link.eap.monitor.record.a.a.a(mac, "getNeighbor");
        }
    }

    private boolean a(String string) {
        RoamingSetting roamingSetting = this.e(string);
        if (null == roamingSetting) {
            return false;
        }
        if (null == roamingSetting.getFastRoaming()) {
            return false;
        }
        return roamingSetting.getFastRoaming().equals(1);
    }

    private IssuedRoamingInfo a() {
        IssuedRoamingInfo issuedRoamingInfo = new IssuedRoamingInfo();
        issuedRoamingInfo.setRequestNeighbor(Integer.valueOf(1));
        return issuedRoamingInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RoamingClient a(ProbeClient probeClient, RoamingRelatedAp roamingRelatedAp) {
        RoamingClient roamingClient;
        Object object;
        String string = probeClient.getMac();
        String string2 = probeClient.getSsid();
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)string);
        synchronized (object2) {
            roamingClient = RoamingClientRecord.getRoamingClient((String)(string + string2));
            if (null == roamingClient) {
                roamingClient = new RoamingClient(string, string2);
            }
            this.a(roamingClient.getApList(), roamingRelatedAp);
            RoamingClientRecord.putRoamingClient((String)(string + string2), (RoamingClient)roamingClient);
        }
        return roamingClient;
    }

    private void a(List<RoamingRelatedAp> list, RoamingRelatedAp roamingRelatedAp) {
        if (null != list) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                RoamingRelatedAp roamingRelatedAp2 = list.get(i2);
                if (!this.a(roamingRelatedAp2, roamingRelatedAp)) continue;
                list.set(i2, roamingRelatedAp);
                return;
            }
        } else {
            list = new ArrayList<RoamingRelatedAp>();
        }
        if (list.size() < e) {
            list.add(roamingRelatedAp);
        } else {
            this.b(list, roamingRelatedAp);
        }
    }

    private void b(List<RoamingRelatedAp> list, RoamingRelatedAp roamingRelatedAp) {
        int n2 = 0;
        if (!CollectionUtils.isEmpty(list)) {
            Long l2 = list.get(n2).getRecvTime();
            for (int i2 = 1; i2 < list.size(); ++i2) {
                Long l3 = list.get(i2).getRecvTime();
                if (l3 >= l2) continue;
                n2 = i2;
                l2 = l3;
            }
            list.set(n2, roamingRelatedAp);
        } else {
            list = new ArrayList<RoamingRelatedAp>();
            list.add(roamingRelatedAp);
        }
    }

    private ApNeighborList a(RoamingRelatedAp roamingRelatedAp, List<RoamingRelatedAp> list) {
        ApNeighborList apNeighborList = new ApNeighborList(roamingRelatedAp.getMac(), roamingRelatedAp.getBssid());
        List list2 = apNeighborList.getApList();
        if (!CollectionUtils.isEmpty(list)) {
            for (RoamingRelatedAp roamingRelatedAp2 : list) {
                ApNeighborList apNeighborList2 = this.d(roamingRelatedAp2.getBssid());
                if (null != apNeighborList2 && apNeighborList2.getRegetNeighbor() != 0) {
                    a.debug("Neighbor ap is locked", (Object)apNeighborList2.getRegetNeighbor());
                    continue;
                }
                String string = this.b(roamingRelatedAp.getMac());
                String string2 = this.b(roamingRelatedAp2.getMac());
                if (null == string || null == string2) {
                    a.debug("centerAp {} site is null or ap {} site is null", (Object)roamingRelatedAp.getMac(), (Object)roamingRelatedAp2.getMac());
                    continue;
                }
                if (this.a(roamingRelatedAp, roamingRelatedAp2) || roamingRelatedAp.getRecvTime() - roamingRelatedAp2.getRecvTime() > (long)b || !string.equals(string2) || roamingRelatedAp.getRecvTime() - roamingRelatedAp2.getRecvTime() < 0L) continue;
                list2.add(roamingRelatedAp2);
            }
        }
        return apNeighborList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(RoamingRelatedAp roamingRelatedAp, ApNeighborList apNeighborList) {
        ApNeighborList apNeighborList2;
        Object object;
        Object object2 = object = com.tp_link.eap.b.b.a.a((String)roamingRelatedAp.getBssid());
        synchronized (object2) {
            apNeighborList2 = this.d(apNeighborList.getBssid());
            if (null == apNeighborList2) {
                apNeighborList2 = apNeighborList;
            } else if (!CollectionUtils.isEmpty((Collection)apNeighborList.getApList())) {
                for (RoamingRelatedAp roamingRelatedAp2 : apNeighborList.getApList()) {
                    boolean bl = false;
                    if (null != apNeighborList2.getApList()) {
                        for (int i2 = 0; i2 < apNeighborList2.getApList().size(); ++i2) {
                            RoamingRelatedAp roamingRelatedAp3 = (RoamingRelatedAp)apNeighborList2.getApList().get(i2);
                            if (!this.a(roamingRelatedAp2, roamingRelatedAp3)) continue;
                            apNeighborList2.getApList().set(i2, roamingRelatedAp2);
                            bl = true;
                            if (null == roamingRelatedAp2.getChannel() || null == roamingRelatedAp3.getChannel() || roamingRelatedAp2.getChannel().equals(roamingRelatedAp3.getChannel())) break;
                            a.debug("channel changed for bssid: {}, old channel: {}, new channel: {}", new Object[]{roamingRelatedAp2.getBssid(), roamingRelatedAp3.getChannel(), roamingRelatedAp2.getChannel()});
                            apNeighborList2.setChanged(true);
                            roamingRelatedAp3.setChannel(roamingRelatedAp2.getChannel());
                            break;
                        }
                    }
                    if (bl) continue;
                    this.a(apNeighborList2, roamingRelatedAp2);
                }
            }
            this.a(apNeighborList2);
        }
        if (apNeighborList2.isChanged()) {
            a.debug("Center AP {} neighbor list is changed, issue\n{}", (Object)apNeighborList2.getMac(), (Object)com.tp_link.eap.util.a.b.a((Object)apNeighborList2));
            apNeighborList2.setChanged(false);
            this.a(apNeighborList2.getMac(), apNeighborList2);
        }
        this.b(roamingRelatedAp, apNeighborList2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void b(RoamingRelatedAp roamingRelatedAp, ApNeighborList apNeighborList) {
        if (!CollectionUtils.isEmpty((Collection)apNeighborList.getApList())) {
            for (RoamingRelatedAp roamingRelatedAp2 : apNeighborList.getApList()) {
                ApNeighborList apNeighborList2;
                Object object;
                Object object2 = object = com.tp_link.eap.b.b.a.a((String)roamingRelatedAp2.getBssid());
                synchronized (object2) {
                    apNeighborList2 = this.d(roamingRelatedAp2.getBssid());
                    if (null == apNeighborList2) {
                        a.debug("Related AP {} not exist", (Object)roamingRelatedAp2.getBssid());
                        continue;
                    }
                    if (null == roamingRelatedAp2.getMac()) {
                        Object object3;
                        a.debug("Related AP {} MAC is null", (Object)roamingRelatedAp2.getBssid());
                        Object object4 = object3 = com.tp_link.eap.b.b.a.a((String)roamingRelatedAp.getBssid());
                        synchronized (object4) {
                            roamingRelatedAp2.setMac(apNeighborList2.getMac());
                            this.a(apNeighborList);
                        }
                    }
                    boolean bl = false;
                    if (!CollectionUtils.isEmpty((Collection)apNeighborList2.getApList())) {
                        for (RoamingRelatedAp roamingRelatedAp3 : apNeighborList2.getApList()) {
                            if (!roamingRelatedAp3.getBssid().equals(roamingRelatedAp.getBssid())) continue;
                            roamingRelatedAp3.setRecvTime(roamingRelatedAp.getRecvTime());
                            bl = true;
                            if (null == roamingRelatedAp.getChannel() || null == roamingRelatedAp3.getChannel() || roamingRelatedAp.getChannel().equals(roamingRelatedAp3.getChannel())) break;
                            a.debug("channel changed for bssid: {}, old channel: {}, new channel: {}", new Object[]{roamingRelatedAp3.getBssid(), roamingRelatedAp3.getChannel(), roamingRelatedAp.getChannel()});
                            roamingRelatedAp3.setChannel(roamingRelatedAp.getChannel());
                            apNeighborList2.setChanged(true);
                            break;
                        }
                    }
                    if (!bl) {
                        this.a(apNeighborList2, roamingRelatedAp);
                    }
                    this.a(apNeighborList2);
                }
                if (!apNeighborList2.isChanged()) continue;
                a.debug("Related AP {} neighbor list is changed, issue {}", (Object)apNeighborList2.getMac(), (Object)com.tp_link.eap.util.a.b.a((Object)apNeighborList2));
                apNeighborList2.setChanged(false);
                this.a(apNeighborList2.getMac(), apNeighborList2);
            }
        }
    }

    private void a(ApNeighborList apNeighborList, RoamingRelatedAp roamingRelatedAp) {
        List list = apNeighborList.getApList();
        if (null != list) {
            if (list.size() < d) {
                list.add(roamingRelatedAp);
            } else {
                list.set(d - 1, roamingRelatedAp);
            }
        }
        apNeighborList.setChanged(true);
    }

    private void a(String string, ApNeighborList apNeighborList) {
        if (null == apNeighborList || null == apNeighborList.getApList()) {
            return;
        }
        a.debug("DATA_TYPE_NEIGHBORLIST: {}", (Object)string);
        com.tp_link.eap.monitor.record.a.a.a(string, "neighborList");
    }

    private boolean a(RoamingRelatedAp roamingRelatedAp, RoamingRelatedAp roamingRelatedAp2) {
        return roamingRelatedAp.getBssid().equals(roamingRelatedAp2.getBssid());
    }

    private boolean a(RoamingClient roamingClient) {
        List list = roamingClient.getApList();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (RoamingRelatedAp roamingRelatedAp : list) {
                if (l.a((long)(roamingRelatedAp.getRecvTime() * (long)c), (long)(b * c))) continue;
                return false;
            }
        }
        return true;
    }

    private String b(String string) {
        String string2 = com.tp_link.eap.d.b.e((String)string);
        if (null == string2) {
            a.debug("AP site is null in roaming");
        }
        return string2;
    }

    private void b(String string, ApNeighborList apNeighborList) {
        String string2 = this.b(string);
        List<Ap> list = this.j.getSiteAdoptedAps(string2);
        if (!CollectionUtils.isEmpty((Collection)apNeighborList.getApList())) {
            Iterator iterator = apNeighborList.getApList().iterator();
            while (iterator.hasNext()) {
                RoamingRelatedAp roamingRelatedAp = (RoamingRelatedAp)iterator.next();
                ApNeighborList apNeighborList2 = this.d(roamingRelatedAp.getBssid());
                if (null != apNeighborList2 && apNeighborList2.getRegetNeighbor() != 0) {
                    iterator.remove();
                    continue;
                }
                boolean bl = false;
                if (!CollectionUtils.isEmpty(list)) {
                    for (Ap ap : list) {
                        if (!this.b(roamingRelatedAp.getBssid(), ap.getMac())) continue;
                        bl = true;
                        roamingRelatedAp.setMac(ap.getMac());
                        break;
                    }
                }
                if (!bl) {
                    String string3 = this.c(roamingRelatedAp.getBssid());
                    if (!CollectionUtils.isEmpty(list)) {
                        for (Ap ap : list) {
                            if (!this.b(string3, ap.getMac())) continue;
                            bl = true;
                            roamingRelatedAp.setMac(ap.getMac());
                            break;
                        }
                    }
                }
                if (bl) continue;
                iterator.remove();
            }
        }
    }

    private String c(String string) {
        if (!com.tp_link.eap.util.p.c.d((String)string)) {
            a.error("Illegal BSSID {}", (Object)string);
            return string;
        }
        String string2 = string.substring(0, 9);
        String string3 = string.substring(9).replace("-", "");
        try {
            int n2 = Integer.parseInt(string3, 16);
            if (0 == n2) {
                return string;
            }
            if ((string3 = Integer.toHexString(--n2).toUpperCase(Locale.ROOT)).length() > 6) {
                return string;
            }
            while (string3.length() < 6) {
                string3 = "0" + string3;
            }
            string3 = string3.substring(0, 2) + "-" + string3.substring(2, 4) + "-" + string3.substring(4);
            return string2 + string3;
        }
        catch (Exception exception) {
            return string;
        }
    }

    private boolean b(String string, String string2) {
        return string.substring(3).equals(string2.substring(3));
    }

    private List<RoamingClient> b() {
        ArrayList arrayList = com.tp_link.eap.util.a.a.a((Iterable)this.f.findAll());
        if (null == arrayList) {
            arrayList = new ArrayList();
        }
        return arrayList;
    }

    private RoamingClient c(String string, String string2) {
        return this.f.findByClientMacAndSsid(string, string2);
    }

    private boolean b(RoamingClient roamingClient) {
        if (null == roamingClient) {
            return false;
        }
        this.f.save(roamingClient);
        return true;
    }

    private List<ApNeighborList> c() {
        ArrayList arrayList = com.tp_link.eap.util.a.a.a((Iterable)this.g.findAll());
        if (null == arrayList) {
            arrayList = new ArrayList();
        }
        return arrayList;
    }

    private ApNeighborList d(String string) {
        return this.g.findByBssid(string);
    }

    private boolean a(ApNeighborList apNeighborList) {
        if (null == apNeighborList) {
            return false;
        }
        this.g.save(apNeighborList);
        return true;
    }

    private RoamingSetting e(String string) {
        String string2 = this.b(string);
        return this.h.findByKeyAndSite("roaming", string2);
    }

    @Override
    public ApNeighborList getApNeighborListByMac(String mac) {
        return this.g.findByMac(mac);
    }

    @Override
    public List<ApNeighborList> getApNeighborListsByMac(String mac) {
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"mac").is((Object)mac));
        return this.k.find(query, ApNeighborList.class);
    }
}

